﻿/*==============================================================================================
   HTML Parsing Blocks. The following vars contain HTML code to be inserted in the Register
   Today HTML pages based on the business logic, e.g., whether the registration is for a company
   or individual, whether an old serial number is needed, whether State/Region/Province is 
   required, etc.

   (C) Copyright 2004 by Autodesk, Inc.  All rights reserved.
  ==============================================================================================*/

/////////////////////////////////////////////
// LOCALIZATION RESOURCES HERE:
/////////////////////////////////////////////

/////////////////////////////////////////////
// Product Language: 
//
// NOTE TO LOCALIZATION: The list below was inserted on 29 Jan 2001 and it was up to date at that point.
// You may use the codes detailed below if you are sure that these have not changed (they generally don't change), otherwise, 
// please check these before inserting the language code.
/////////////////////////////////////////////
//
//English - US and International:  (en-us)
//German:  (de)
//French:   (fr)
//Italian:   (it)
//Spanish:   (es)
//Czech:   (cs)             
//Hungarian:   (hu)
//Polish:   (pl)
//Russian:   (ru)
//Japanese:   (ja)
//Korean:   (ko)
//Traditional Chinese (Taiwan) :   (zh-tw)
//Simplified Chinese (PRC) :   (zh-cn)
//Brazilian Portuguese (pt-br)
//
/////////////////////////////////////////////

//////////////////////////////////////////////
///// Add as ECO17 Direct Addition to the Privacy Policy 
/////
var xmsgGatherInfoDuringInstall= "Обратите внимание на то, что все данные, собранные в процессе активации продукта, используются в соответствии с Autodesk ";
var xmsgOfflinePrivacyWarning= "Чтобы прочитать положения политики конфиденциальности при отсутствии подключения к Интернету, установите автоматический выбор кодировки в обозревателе Internet Explorer (R) . При наличии подключения к Интернету положения политики конфиденциальности также доступны в интерактивном режиме на сайте autodesk.com"
////////////////////////////////////////////////////

var xmsgProductLanguage=	"ru";

/////////////////////////////////////////////
// Disable field color
/////////////////////////////////////////////
var xmsgDisableColor=		"#7f7f7f";

var xmsgNavigationBGColor=	"#f4f4f4";
var xmsgNavigationDisableColor=	"#808080";

/////////////////////////////////////////////
// HTML FILE TITLE STRINGS
/////////////////////////////////////////////
var xmsgRTAuthConfirmed=				"Подтверждение авторизации";
var xmsgRTActLicFound=                  "Найдена активированная лицензия";
var xmsgRTActLicFoundError=            "Ошибка регистрации/активации"; 
var xmsgRTAuthEntryError=				"Ошибка в данных для активации";
var xmsgRTAuthError=					"Ошибка при активации";
var xmsgRTAuthNow=						"Авторизация продукта";
var xmsgRTBeginReg=						"Начало регистрации";
var xmsgRTBuyInformation=				"Информация о приобретении продукта";
var xmsgRTConfirm=						"Подтверждение информации";
var xmsgRTConnect=						"Связь с Интернетом";
var xmsgRTConnectFail=					"Ошибка подключения";
var xmsgRTContactAutodesk=				"Связаться с Autodesk";
var xmsgRTCountryPage=					"Страна местонахождения";
var xmsgRTEmail=						"Регистрация по e-mail";
var xmsgRTFaxUS=						"Регистрация по факсу (США)";
var xmsgRTMailUS=						"Регистрация по почте (США)";
var xmsgRTPurchaseOffline=				"Приобретение по Интернету невозможно";
var xmsgRTRegConfirmed=					"Подтверждение регистрации";
var xmsgRTExportConfirm=                "Подтверждение экспорта лицензии";
var xmsgRTImportConfirm=                "Подтверждение импорта лицензии"; 
var xmsgRTRegVol=						"Регистрация продукта";
var xmsgRTSUNDataConfirm=				"Подтверждение сохранения данных";
var xmsgRTSUNServer=					"Сервер ЛС";
var xmsgRTSUNSubmit=					"Подтверждение и отправка данных";
var xmsgRTUserInfo=						"Сведения о пользователе";
var xmsgRTLicFileSaveError=				"Ошибка сохранения файла лицензий Flexlm";
var xmsgRTProductInfo=                   "Информация о продукте"; //add by joyce.min on 2007-8-14
var xmsgNSARTBegin=						"Получение сетевой лицензии";
var xmsgNSARTLocateLicense=				"Поиск файла лицензий";
var xmsgNSARTEditServerAndSeat=			"Ввод/изменение сведений о сервере";
var xmsgNSARTConfirmServerAndSeat=		"Подтверждение сведений о сервере";
var xmsgNSARTEnterSN=					"Ввод серийного номера";
var xmsgProcessingError=				"Ошибка при обработке";
var xmsgTimeout=        				"Сеанс прерван по превышению времени ожидания";

/////////////////////////////////////////////
// Software Information RESOURCES HERE:
/////////////////////////////////////////////
var xmsgActivationFor=	"Активация для:";
var xmsgPurchase=       "Приобретение:";
var xmsgRegistrationFor=       "Регистрация для:";
var xmsgProduct=	"Продукт: ";
var xmsgsernum=		"Серийный номер: ";
var xmsgsernumWGID=	"Серийный номер или код группы: ";//modify by joyce.min on 2007-8-16
var xmsgprokeyWGID=  "Ключ продукта: "; // add by  joyce.min on 2007-8-16
var xmsgOsernum=	"Прежний серийный номер: ";
//var xmsgOprokey=      "Previous product key: "; // add by joyce.min on 2007-8-17
var xmsgOldSerialNum=	"Прежний серийный номер*:";
var xmsgNewSernum1=	"Введите серийный номер или код группы:"; //???
//var xmsgNewProkey1=
var xmsgRequestCode=	"Код запроса: ";
var xmsgRegAuthCode=	"Код активации: ";
var xmsgApplicationKey=	"Ключ приложения: ";
var xmsgRTHostID=				"ID хоста:";
var xmsgRTFlexlmLicenseFile=	"Файл лицензий:";

/////////////////////////////////////////////
// Primary Rolodex RESOURCES HERE:
/////////////////////////////////////////////
var xmsgSalutation=	"Обращение:";
var xmsgNone=		"(нет)";
var xmsgNotEntered=	"(не введен)";
var xmsgFirstname=	"Имя:";
//var xmsgFirstname= langCode+label.fname;
var xmsgFirstnameKanji=	"Имя (кандзи):";
var xmsgFirstnameFurigana=	"Имя (дзенкаку кана):";
var xmsgLastname=	"Фамилия:";
var xmsgLastnameKanji=	"Фамилия (кандзи):";
var xmsgLastnameFurigana=	"Фамилия (дзенкаку кана):";
var xmsgCompanyName=	"Организация:*";
var xmsgCompanyName2=	"Организация:";
var xmsgCompanyNameJP=	"Организация (кандзи):";
var xmsgPhone=		"Телефон:";
var xmsgArea=		"Площадь:";
var xmsgNumber=		"Номер:";
var xmsgExt=		"Доб. номер:";
var xmsgFax=		"Факс:";
var xmsgFaxTo=		"Факс получателя ";
var xmsgEmail=		"Электронная почта:";
var xmsgEmailTo=	"Электронная почта получателя ";
var xmsgAddress=	"Адрес, улица:";
var xmsgAddress2=	"Адрес, улица (2):";
var xmsgAddress3=	"Адрес, улица (3):";
var xmsgJPAddress=	"Город:";
var xmsgJPAddress2=	"Адрес, улица:";
var xmsgJPAddress3=	"Номер строения (и квартиры/офиса):";
var xmsgCity=		"Город:";
var xmsgSRP=		"Штат/Область/Провинция:";
var xmsgStText=		"Штат:";
var xmsgPrText=		"Провинция:";
var xmsgRegText=	"Область:";
var xmsgPrefectureText=	"Префектура:";
var xmsgCountyText=	"Округ/графство:";
var xmsgCantonText=	"Кантон:";
var xmsgZipCode=	"Почтовый индекс:";
var xmsgPostCode=	"Почтовый индекс:";
var xmsgCountry=	"Страна или территория:";
var xmsgDealer=		"Имя авторизованного дилера Autodesk:";
var xmsgMailTo=		"Почтовый адрес отправителя ";
var xmsgAnEmail=	"адрес электронной почты";
var xmsgAFax=		"номер факса";
var xmsgAMailAddress=	"почтовый адрес";
var xmsgPostalMail=		"Доставка по почте";

///////////////////////////////////////////////
// Button RESOURCES HERE:
///////////////////////////////////////////////
var xmsgBack=			"<< Назад";
var xmsgCancel=			"Закрыть";
var xmsgNext=			"Далее >>";
var xmsgPrint=			"Печать";
var xmsgPrintForm=		"Открыть форму запроса об активации";
var xmsgNo=				"Нет";
var xmsgYes=			"Да";
var xmsgBrowse=			"Обзор";
var xmsgDone=			"Готово";
var xmsgOK=				"OK";
var xmsgClose=			"Закрыть";
var xmsgSubmit=			"Отправить";
var xmsgFinish=			"Готово";
var xmsgReset=			"Очистить все";

///////////////////////////////////////////////
// Registration User Prompt RESOURCES HERE:
///////////////////////////////////////////////
var xmsgPleaseSelect=		"Выберите ";
var xmsgPleaseSelect2=		"Выберите нужный вариант и нажмите кнопку \"Далее\".";
var xmsgSelectCountry=		"Страна/регион, в котором будет использоваться продукт:";
var xmsgSelectCountry2=		"Страна/регион:";
var xmsgInformation=		"Информация";
var xmsgCompanyInfo=		"Сведения об организации:";
var xmsgContactInfo=		"Информация для контактов:";
var xmsgResponseMethodInfo=	"Информация о способе отправки ответа:"; //modify as the Spec. recommond by joyce.min on 2007-8-17
var xmsgFormSubmitMethodInfo=	"Способ отправки формы:";
var xmsgConfirmInfo=		"Подтверждение данных";
var xmsgConfirmInfoTxt=		"Проверьте приведенные здесь данные. Для продолжения выберите в форме одну из ссылок способа отправки или нажмите \"Назад\", чтобы внести изменения.";
var xmsgConfirmCustIDInfoTxt=		"Проверьте правильность введенных данных. Для продолжения нажмите \"Далее\", для изменения данных -- \"Назад\".";
var xmsgCountryHdr=			"Регистрация продукта";
var xmsgCountryRegTo=		"Этот продукт будет зарегистрирован на имя:";
var xmsgCountryComp=		"Организацию";
var xmsgCountryIndiv=		"Частное лицо";
var xmsgCountryUpgrade=		"Это является обновлением";
var xmsgCountryUpgDetail=	"(Участникам программы подписки следует отвечать \"Нет\")";
var xmsgConnectHdr1=		"Связь с  Интернетом";
var xmsgConnectHdr=		"Подключение к Интернету";
var xmsgConnectMsg=		"Подключение";
var xmsgConnectTxt=		"Подключение к Интернету не обнаружено. Чтобы отправить интерактивный запрос, выполните подключение к Интернету.";
var xmsgConnectTxtOLT=    "Подключение к Интернету не обнаружено. Для переноса лицензии выполните подключение к Интернету.";
var xmsgConnectTxt2=	"После установки подключения к Интернету нажмите кнопку \"Далее\".";
var xmsgConnectTxt3=	"Чтобы использовать другой способ отправки запроса, щелкните следующую ссылку:";
var xmsgConnectWarming=	"Отправка этой информации может занять несколько минут. Подождите.";
var xmsgTryAgain=		"Повторить";
var xmsgReEnterOld=		"Повторить ввод серийного номера";
var xmsgNewSernum3=		"Введите новый серийный номер и нажмите \"Далее\".";
var xmsgNewSernum4=		"Ознакомительная версия была установлена с серийным номером 000-00000000, регистрация на который невозможна. На приобретенной полной версии указан другой серийный номер. Именно его нужно использовать для активации продукта.";
var xmsgNewSernum5=		"Введите серийный номер или код группы:"; //modify by joyce.min on 2007-8-16
var xmsgProductKey=      "Введите ключ продукта:"; //modify by joyce.min on 2007-8-16
var xmsgNewSernum6=		"Подтверждение нового серийного номера:";
var xmsgNewSernum8=		"Повторить ввод нового серийного номера";
var xmsgUseOtherMethod=		"Выбрать другой способ регистрации";
var xmsgContactAutodesk=	"Связаться с Autodesk";
var xmsgContactAutodeskLink="Для обращения в Autodesk щелкните следующую ссылку:";
var xmsgContactOptions=		"способы связи указаны ниже.";

var xmsgPuchaseInfo1=		"Информация о приобретении продукта";
var xmsgPuchaseInfo2=		"Вы приняли решение приобрести продукт по Интернету."; //modify as the LF1_Spec_SCV commend on p99 by joyce.min
var xmsgPuchaseInfo3=		"Нажмите \"Далее\" для продолжения или \"Отмена\" для отказа."; //modify as the LF1_Spec_SCV commend on p99 by joyce.min

var xmsgRegTitle=		"Регистрация - активация";
var xmsgRegTitleBuy=		"Приобретение продуктов Autodesk по Интернету";
var xmsgRegTitleNSA=		"Активация сетевой лицензии";
var xmsgRegInfo=		"Данные о пользователе";
var xmsgRegInfo2=		"Способ регистрации";
var xmsgRegInfo3=		"Выберите способ регистрации и нажмите \"Далее\".";
var xmsgRegmethod1=		"По Интернету";
var xmsgRegmethod3=		"Я хочу получить код активации следующим способом:";
var xmsgRegmethod5=		"Адрес";
var xmsgRegmethod6=		"Нажмите кнопку \"Печать\" и отправьте форму по адресу:";
var xmsgRegmethod7=		"Факс";
var xmsgRegmethod8=		"Чтобы распечатать форму, которую можно отправить в Autodesk по адресу %1, сначала выберите способ для получения кода активации. Затем нажмите кнопку Печать. После этого форму можно отправить по факсу.";
var xmsgRegmethod9=		"Регистрация по e-mail";
var xmsgRegmethod10NSA=		"Регистрационная информация и сведения о сервере лицензий (см. ниже) сохранена в файле.";
var xmsgRegmethod10=		"Ваша регистрационная информация была сохранена в следующий файл, который будет использоваться при отправке электронной почты (не вносите изменения в этот файл):";
var xmsgRegmethod11NSA=		"Отправьте файл %1 с регистрационной информацией и сведениями о сервере лицензий по адресу %2.";
var xmsgRegmethod11=		"Отправьте файл %1 с информацией по адресу %2.";
var xmsgRegmethod12=		"Не следует изменять этот файл.<p>Рекомендуется распечатать его копию и хранить ее в надежном месте. Информация из файла понадобится для дальнейшего обмена по электронной почте.<p>Вы можете распечатать эту страницу для своего архива. Нажмите кнопку \"Готово\" для ее закрытия.";
var xmsgRegmethod13=		"Чтобы автоматически вложить и отправить %1 в Autodesk, щелкните ссылку ниже.";
var xmsgRegmethod14=		"Отправить запрос по электронной почте";
var xmsgRegmethod15=		"Примечание. Адрес электронной почты указывается автоматически. Не отправляйте на этот адрес сообщения электронной почты.";
var xmsgRegmethod16=		"Для регистрации по факсу или электронной почте щелкните одну из следующих ссылок:";
var xmsgRegmethod17=		"Ошибка при отправке сообщения";
var xmsgRegmethod18NSA=		"При попытке автоматической отправки регистрационной информации и сведений о сервере лицензий произошла ошибка.";
var xmsgRegmethod18=		"При попытке автоматической отправки регистрационной информации произошла ошибка.";
var xmsgRegmethod19=		"Для отправки файла вручную:";
var xmsgRegmethod20NSA=		"Отправьте файл %1 с регистрационной информацией и сведениями о сервере лицензий по адресу %2.";
var xmsgRegmethod20=		"Отправьте файл %1 с информацией по адресу %2.";
var xmsgRegmethod21=		"Не следует изменять этот файл.<p>Рекомендуется распечатать его копию и хранить ее в надежном месте. Информация из файла понадобится для дальнейшего обмена по электронной почте.<p>Вы можете распечатать эту страницу для своего архива. Нажмите кнопку \"Готово\" для ее закрытия.";
var xmsgRegAuthInfo=		"Активация";
var xmsgRegAuthInfo1=		"Подтверждение регистрацииПодтверждение";
var xmsgRegExpConfirm=      "Подтверждение экспорта лицензии";
var xmsgRegImpConfirm=      "Подтверждение импорта лицензии";
var xmsgRegAuthInfo2=		"Получение кода активации";
var xmsgRegAuthInfo3=		"Ввести код активации"; 
var xmsgRegAuthInfo4=		"Выберите параметр из приведенного ниже списка:";
var xmsgRegAuthInfo4A=		"Введите код активации";
var xmsgRegAuthInfo4B=		"Введите код активации:"; 
var xmsgRegAuthInfo5=		"Выберите страну или территорию, введите код активации и нажмите \"Далее\".";
var xmsgRegAuthInfo6=		"Регистрация - подтверждение активации";	
var xmsgRegAuthInfo7=		"Благодарим вас за регистрацию и активацию продукта.";
var xmsgRegAuthInfo8=		"Подтверждение";		
var xmsgRegAuthInfo9=		"Благодарим Вас за регистрацию продукта Autodesk. Это поможет нам в дальнейшем учитывать Ваши потребности.";
var xmsgRegAuthInfo10=		"Копия информации о регистрации сохранена в следующем месте:";		
var xmsgRegAuthInfo10B=		"Копия информации о регистрации сохранена в следующем месте:";
var xmsgRegActLicInfo=      "Найдена активированная лицензия";
var xmsgRegActLicInfoError=      "Ошибка регистрации/активации";
var xmsgRegActiveInfo=        "Введите или найдите в файловой системе файл активации:";
var xmsgRegActLicInfo1=       "На компьютере обнаружена ранее зарегистрированная и активированная лицензия для данного продукта."
var xmsgRegActLicInfo1Error= "На компьютере обнаружена ранее зарегистрированная и активированная лицензия для данного продукта.\n Однако возникла непредвиденная ошибка (%1). Завершите работу приложения и повторите попытку. Если неполадка сохраняется, обратитесь к системному администратору или в уполномоченное представительство по распространению продуктов Autodesk";

/////////////////////////////////////////////
// OLT Confirmation
/////////////////////////////////////////////
var xmsgExportSuccess=        "Экспорт выполнен успешно"; //2008-01-16
var xmsgExportFail=           "Сбой при выполнении запроса на экспорт" ; //2008-01-16
var xmsgRegErrRef=            "Справочник по ошибкам:"; //2008-01-17
var xmsgImportSuccess=        "Импорт выполнен успешно"; //2008-01-16
var xmsgImportFail=           "Сбой при выполнении запроса на импорт"; //2008-01-16
var xmsgExpSucessInfo=        "Лицензия успешно экспортирована и теперь находится на сервере Autodesk."; //2008-01-16
var xmsgExpSuccessInfoHowtoImport=    "Процедура импорта лицензии";
var xmsgExpSucessInfo1=        "Перед запуском продукта на компьютере-адресате следует импортировать данную лицензию на указанный компьютер с помощью утилиты переноса лицензий, а также подготовить идентификатор и пароль пользователя Autodesk, которые потребуется ввести.";  //2008-01-16
var xmsgImpSucessInfo=         "Лицензия успешно импортирована; теперь можно работать с данным продуктом. "; //2008-01-16
var xmsgImpRemindInfo=         "Отображать напоминание об экспорте."; //2008-01-16
var xmsgImpRemindInfo1=        "Если этот флажок установлен, каждый раз при завершении работы отображается диалоговое окно с напоминанием об экспорте лицензии.";//copy mockup 2008-01-16
var xmsgImpRemindInfo2=        "Этот режим удобен, когда лицензия импортируется на компьютер временно и потребуется перенести ее обратно.";//copy mockup 2008-01-16
var xmsgImpRemindInfo3=        "В диалоговом окне напоминания можно выбрать режим \"больше не выводить это окно\".";//copy mockup 2008-01-16
var xmsgOltTryAgain=           "Щелкните на ссылке \"Повторить\" для повторной отправки запроса. ";
var xmsgImpFailMsg=            "Если неполадка сохраняется, следует вместо импорта лицензии активировать ее.";

var xmsgReqfilelocMsg=       "Местоположение запрашиваемого файла:";	//add by joyce.min on 2007-9-10 as Licensing Spec. recommend 	
var xmsgRegAuthInfo11=		"Благодарим вас за регистрацию. Ваш продукт активирован, а файл лицензии сохранен. Нажмите кнопку Печать, чтобы сохранить эту информацию для последующего обращения к ней.";
var xmsgRegAuthInfo12=		"Вставьте код активации.";
var xmsgRegAuthInfo13=		"Введите код активации.";
var xmsgRegErrorActiveCode=    "<FONT color=red>Для продолжения введите код активации.</FONT>";
var xmsgRegErrorActiveCode1=    "<FONT color=red>Недопустимый код активации. Проверьте наличие ошибок в коде.</FONT>";
var xmsgRegErrorActiveFile=    "<FONT color=red>Для продолжения введите путь к файлу активации и его имя.</FONT>";
var xmsgRegErrorSernum=      "<FONT color=red>Для продолжения введите серийный номер.</FONT>"; //add by joyce.min on 2007-8-29
var xmsgRegErrorSernum1=      "<FONT color=red>Слишком короткий серийный номер.</FONT>"; //add by joyce.min on 2007-9-7
var xmsgRegErrorProkey=      "<FONT color=red>Для продолжения введите ключ продукта.</FONT>"; //add by joyce.min on 2007-8-29
var xmsgRegErrorProkey1=     "<FONT color=red>Слишком короткий ключ продукта.</FONT>"; //add by joyce.min on 2007-9-7
var xmsgRegErrorHdr=		"Регистрация - ошибка активации";
var xmsgRegErrorSystem=		"Временный сбой системы вызывает ошибки регистрации. Щелкните одну из следующих ссылок."
var xmsgRegErrorPrevReg=	"Продукт с введенным серийным номером уже зарегистрирован.";
var xmsgRegErrorMaxAuth=	"Вы превысили число активаций, разрешенное для данного продукта.";
var xmsgRegErrorMaxAuth2=	"Вы превысили число лицензий, разрешенное для данного продукта.";
var xmsgRegErrorInvalidOld=	"Серийный номер, введенный для предыдущего продукта, является недействительным. Проверьте правильность отображаемого выше предыдущего серийного номера. Щелкните одну из следующих ссылок.";
var xmsgRegErrorData=		"Возникли затруднения с обработкой введенных регистрационных данных. Выберите \"Повторить\", чтобы просмотреть и исправить их, либо воспользуйтесь другим способом регистрации. Если затруднения будут продолжаться, обратитесь в компанию Autodesk.";
var xmsgRegErrorNetwork=	"Продукт, попытка регистрации которого предпринимается, предназначен для работы в сети и должен устанавливаться соответствующим образом. Требуется выполнить удаление установки и выбрать тип установки \"Сетевая\".<p>См. раздел руководства по установке, посвященный сетевой установке, где приведены надлежащие процедуры установки и активации для сетевой версии.";
var xmsgRegNoResponse=		"Временный сбой вызывает ошибки регистрации через Интернет. Щелкните одну из следующих ссылок.";
var xmsgRegErrorAuthEntry=	"Возникла проблема с введенным кодом активации. Щелкните одну из следующих ссылок.";
var xmsgRegErrorAuthPermission = "Для активации данного продукта Autodesk необходимо либо иметь права администратора, либо получить у администратора системы повышенные права.";							
var xmsgRegErrorAuth=		"Возникла проблема с кодом активации. Щелкните одну из следующих ссылок.";
var xmsgRegErrorFlex=		"Возникла проблема с лицензией. Щелкните одну из следующих ссылок.";
var xmsgRegConnError=		"Ошибка подключения";
var xmsgRegConnErrorTxt=	"Возникла проблема с подключением к Интернету. Щелкните одну из следующих ссылок.";
var xmsgRegPurchError3=		"Используйте другой способ покупки";
//modified as LFSpec_SCV commend by joyce.min
var xmsgRegPurchError5=		 "Благодарим Вас за выбор продукта компании Autodesk.<p>К сожалению, приобретение по Интернету сейчас невозможно.<p>Для продолжения процедуры приобретения выберите один из следующих вариантов (при этом откроется новое окно браузера).<p>";

var xmsgAuthResellerMsg1=	"Приобретение у регионального дилера. Для того чтобы завершить процедуру приобретения, свяжитесь с региональным дилером компании.";

var xmsgLicSaveErrInfo=		"Произошла ошибка при сохранении файла лицензии. Щелкните одну из следующих ссылок.";

var xmsgOnlineStoreMsg1=	"Приобретение в Интернет-магазине Autodesk. Если там нет нужного продукта, обратитесь к авторизованному дилеру компании.";
var xmsgOnlineStoreMsg2=    "Интернет-магазин";
var xmsgAuthResellerMsg2=	"Авторизованный дилер";
var xmsgLocateLicenseMsg1=	"Поиск файла лицензий";
var xmsgLocateLicenseMsg2=	"Введите путь к файлу лицензий (или найдите его с помощью кнопки \"Обзор\"), а затем нажмите \"Далее\".";
var xmsgLocateLicenseMsg3=	"Существующий файл лицензий:";
var xmsgUserContactMsg=		"Необходимо ввести хотя бы одно из следующего:";
var xmsgFailureMsg=		    "Обработка запроса на активизацию в интерактивном режиме невозможна.";

/////////////////////////////////////////////
// Default Ereg returned error messages
/////////////////////////////////////////////
var xmsgDefaultEregReturnedErrMsg=  "Запрос об активации в интерактивном режиме возвратил код ошибки (%1), что не позволяет обработать данный запрос с помощью автоматизированных систем Autodesk.";
var xmsgRegErrorOnline=		"Нажмите кнопку мыши на приведенной ниже ссылке \"Использовать другой способ\" для заполнения необходимых форм и отправки запроса в региональный офис Autodesk. Представитель службы по работе с клиентами даст ответ в течение следующих 2 рабочих дней.";
var xmsgAnotherFormSubmitMethod=    "Использовать другой способ";

/////////////////////////////////////////////
// Timeout message
/////////////////////////////////////////////
var xmsgTimeoutMsg1=    "Превышено время ожидания для запроса активации в интерактивном режиме."
var xmsgTimeoutMsg2=    "Выберите ссылку \"Повторить\" для повторной отправки запроса в интерактивном режиме.Если неполадка не устраняется, можно выбрать ссылку \"Использовать другой способ\", чтобы отправить запрос по электронной почте, по факсу или другим способом.";

/////////////////////////////////////////////
// Single User Network RESOURCES HERE:
/////////////////////////////////////////////
var xmsgRegSunData1=		"Регистрационные данные сохранены";
var xmsgRegSunData2=		"Регистрационные данные, необходимые для клиентского развертывания, сохранены в ";
var xmsgRegSunData3=		"Введенный Вами прежний серийный номер неверен. Обратитесь к системному администратору.";
var xmsgRegSunData4=		"Необходимо переустановить продукт, используя правильный серийный номер.";
var xmsgRegSunData5=		"Развертывание отдельной версии на несколько пользователей";
var xmsgRegSunData6=		"Для развертывания отдельной версии на несколько пользователей требуется некоторая регистрационная информация. Сейчас программа выполнит следующие действия:";
var xmsgRegSunData7=		"Соберет всю требуемую информацию";
var xmsgRegSunData8=		"Введите предыдущий серийный номер, если это требуется для выполнения обновления.";
var xmsgRegSunData9=		"Сохранит информацию на сервере для последующего развертывания по клиентам";
var xmsgRegSunData10=		"Продукт будет зарегистрирован с использованием указанных ниже данных. Для продолжения нажмите \"Далее\".";

/////////////////////////////////////////////
// Voluntary RESOURCES HERE:
/////////////////////////////////////////////
var xmsgRegVol1=	"Регистрация продукта";
var xmsgRegVol2=	"Выберите нужную опцию и нажмите\"'Далее\":";
var xmsgRegVol3=	"Зарегистрироваться сейчас - переход к регистрации продукта по Интернету";
var xmsgRegVol4=	"Зарегистрироваться позже - запуск продукта без его регистрации";
var xmsgRegVol5=	"Больше не выводить это окно.";
var xmsgRegVol6=	"(Впоследствии для регистрации можно будет выбрать соответствующую опцию в окне информации о программе (меню Справка -> О программе)";

/////////////////////////////////////////////
// Japan RESOURCES HERE:
/////////////////////////////////////////////
var xmsgCustIDMainTitle=	"Идентификация пользователя";
var xmsgKatakana=		    "Организация (дзенкаку кана):";
var xmsgDepartment=		    "Подразделение:";
var xmsgDepartment2=		"Department name:";

/////////////////////////////////////////////
// Autodesk Contact RESOURCES HERE:
/////////////////////////////////////////////
var xmsgFormWebHdr=	"В Интернете:";
var xmsgFormWebDataMsg1= "Код активации можно также получить по следующему адресу:<br>";
var xmsgFormEmailHdr=	"Электронная почта:";
var xmsgFormEmailData=	"";
var xmsgFormEmailDataBlock= "";
var xmsgFormEmailXMLData=	"";
var xmsgFormEmailXMLDataBlock= "";
var xmsgFormFaxHdr=		"Факс:";
var xmsgFormFaxHdrLocal=	"Факс в региональный офис:";
var xmsgFormFaxHdrReg=	"Регистрация по факсу:";
var xmsgFormFaxData=	"";
var xmsgFormFaxDataRegister=	"";
var xmsgFormCallHdr=	"Телефон:";
var xmsgFormCallData=	"";
var xmsgFormMailHdr=	"Почта:";
var xmsgFormMailHdrLocal=	"Письмо в региональный офис:";
var xmsgFormMailHdrReg=	"Регистрация по почте:";
var xmsgFormMailData=	"";
var xmsgFormMailDataRegister=   "";
var xmsgFormPurchHdr=	"Приобретение продукта";
var xmsgFormInternetMsg=    "Щелкните на ссылке для отправки запроса кода активации с помощью обозревателя Интернета."
var xmsgFormEmailMsg=       "Отправлять корреспонденцию и запросы об активации по адресу электронной почты:"

/////////////////////////////////////////////
// Privacy Statement RESOURCES HERE:
/////////////////////////////////////////////

var JPprivacystatement = "Предоставленная вами информация будет использована Autodesk для регистрации и/или предоставления вам кода доступа. Факт регистрации подтверждает ваше согласие с тем, что Autodesk может предоставлять информацию о вас своим авторизованным бизнес-партнерам с целью управления лицензиями на продукты и проверки прав на их использование. Обратитесь в Autodesk по адресу <a href=mailto:information@autodesk.jp>information@autodesk.jp</a>, если вы не хотите, чтобы Autodesk предоставляла информацию о вас своим авторизованным бизнес-партнерам для этих ограниченных целей.    Если вам потребуется исправить или обновить свои регистрационные данные, щелкните ссылку <a %1>HERE</a>, чтобы обратиться в Autodesk, или обратитесь в местное отделение Autodesk.";
			
var privacystatement = "Предоставленная вами информация будет использована Autodesk для регистрации и/или предоставления вам кода доступа, информации о наших продуктах и услугах, а также обеспечения вам преимуществ как авторизованному пользователю Autodesk. Autodesk не продает и не предоставляет никакими иными способами информацию о вас никому, кто не имеет отношения к компании Autodesk или ее авторизованным бизнес-партнерам. Если вам потребуется исправить или обновить свои ранее зарегистрированные данные о пользователе, щелкните <a %1>ЗДЕСЬ</a>, чтобы обратиться в Autodesk, или обратитесь в местное отделение Autodesk.";
				
			
/////////////////////////////////////////////
// Privacy Policy
/////////////////////////////////////////////
var xmsgPrivacyPolicy="Политика защиты конфиденциальной информации";

/////////////////////////////////////////////
// Copyright
/////////////////////////////////////////////
var xmsgCopyright="(c) 2009 Autodesk, Inc. Все права защищены."; //modify by joyce.min on 2007-8-14

/////////////////////////////////////////////
// Rebranding Message
/////////////////////////////////////////////
var xmsgRebranding="В большинстве случаев новый серийный номер отображается после перезапуска программы с правами администратора.";
var xmsgRebranding2="Сведения о запуске программы с правами администратора см. в документации по операционной системе.";
/////////////////////////////////////////////
//  Note to Localization :
//
//	"InsertRegInfo" appears in RTUserInfo.html.  The full sentence in English is
//
//	"Fields marked in <FONT color=red>red</FONT> and with an asterisk (<FONT 
//	color=red>*</FONT>) are required to process your registration. Complete the form 
//	and click Next."
//
/////////////////////////////////////////////
var xmsgRegInfoMsg1= "Поля, помеченные знаком звездочки <FONT color=red>*</FONT>, обязательны для заполнения.";
var xmsgRegInfoMsg2= "Данные, введенные на этой странице, хранятся вместе с лицензией. Они используются для повторной активации и обновления продукта. Во избежание задержек в использовании продукта проверьте правильность вводимых данных.";

var xmsgLicLocationText1 = "Сохранить файл лицензий для <b>%1</b> в:";

// Set Registration Info Header
var InsertRegInfo =     "<p><b>"+xmsgRegInfo+"</b></p>" +
			  "<p>" + xmsgRegInfoMsg1 + "</p>";


//=======================================================================
// Application Usage Information
//=======================================================================
var xmsgAppUsage=	"Вопросы.";

var xmsgAppUsageQ1=	"Чтобы помочь Autodesk лучше понять потребности Вашей отрасли, ответьте, пожалуйста, на следующий вопрос.";
var xmsgAppUsageQ2=	"Что из приведенного ниже больше всего подходит к области Вашей работы?";

var xmsgAppUsageOption51=	"Проектирование изделий авиационной и автомобильной промышленности ";
var xmsgAppUsageOption52=	"Архитектура ";
var xmsgAppUsageOption53=	"Управление в строительстве и инженерных коммуникациях ";
var xmsgAppUsageOption54=	"Строительство офисных зданий ";
var xmsgAppUsageOption55=	"Строительство жилых зданий ";
var xmsgAppUsageOption56=	"Производство строительного оборудования ";
var xmsgAppUsageOption57=	"Гражданское строительство / землеустройство ";
var xmsgAppUsageOption58=	"Проектирование компьютерного / медицинского / офисного оборудования ";
var xmsgAppUsageOption67=	"Разработка потребительских товаров ";
var xmsgAppUsageOption59=	"Владение корпоративным зданием ";
var xmsgAppUsageOption92=	"Оборона ";
var xmsgAppUsageOption93=	"Проектирование электрических КИП ";
var xmsgAppUsageOption94=	"Разработка электротехнических систем ";
var xmsgAppUsageOption72=	"Охрана окружающей среды ";
var xmsgAppUsageOption95=	"Изготовление металлических изделий ";
var xmsgAppUsageOption96=	"Дизайн интерьеров ";
var xmsgAppUsageOption97=	"Проектирование оборудования ";
var xmsgAppUsageOption98=	"Обеспечение производства / Продажа / Маркетинг ";
var xmsgAppUsageOption40=	"Картография ";
var xmsgAppUsageOption41=	"Разработка механических систем (ОВК и трубопроводы) ";
var xmsgAppUsageOption42=	"Разработка водопроводных и пожарозащитных систем ";
var xmsgAppUsageOption43=	"Проектирование электростанций ";
var xmsgAppUsageOption44=	"Проектирование недвижимости ";
var xmsgAppUsageOption45=	"Проектирование зданий и сооружений ";
var xmsgAppUsageOption87=	"Телекоммуникации ";
var xmsgAppUsageOption46=	"Инструменты и формы / Машинный цех ";
var xmsgAppUsageOption47=	"Проектирование транспортных средств ";
var xmsgAppUsageOption48=	"Коммунальные услуги: электричество, нефть и газ ";
var xmsgAppUsageOption49=	"Коммунальные услуги: водопровод и канализация ";
var xmsgAppUsageOption99=	"Другое ";

var xmsgWrongCountryCodeMsg=	"Ошибка: Неизвестный код страны!";

/////////////////////////////////////////////
// Version RESOURCES HERE:
/////////////////////////////////////////////
var xmsgVersion = "Версия:"

/////////////////////////////////////////////
// Access RTFax or RTMail through RTEmail
/////////////////////////////////////////////
var xmsgAccessFaxMsg=		"Запрос будет отправлен по факсу или телефону"; //modify by joyce.min on 2007-10-18 as Licensing_Framework Spec_Frozen.doc recommend 
var xmsgAccessMailMsg=		"Регистрация по обычной почте:";
var xmsgAccessHereMsg=		"здесь.";

/////////////////////////////////////////////
// Receive code by
/////////////////////////////////////////////
var xmsgReceiveCodeMsg=     "Способ получения кода:";
var xmsgReceiveCodeMsg1=     "Получить файл активизации по электронной почте"; //add by joyce.min on 2007-8-20
/////////////////////////////////////////////
// Messages for Ease of reauth or multi-seat client registration
/////////////////////////////////////////////
var xmsgNoDialogHdrMsg=		"Подождите, выполняется проверка <br>вашей лицензии";
/////////////////////////////////////////////
//Resource for RTProductInfo
/////////////////////////////////////////////
var xmsgRTProductInfoTitle=      "Информация о продукте"; //add by joyce.min on 2007-8-14
var xmsgRTProductInfoMsg1=        "Все поля являются обязательными."; //add by joyce.min on 2007-8-14
/////////////////////////////////////////////
//Error for RTProductInfo
/////////////////////////////////////////////
//var xmsgsernumError=        "Enter a serial number to proceed."; //add by joyce.min on 2007-8-17
//var xmsgprokeyError=        "Enter a product key to proceed." ; //add by joyce.min on 2007-8-17
/////////////////////////////////////////////
// Resource for NSA_RTBegin.html
/////////////////////////////////////////////
var xmsgNSARTBeginTitle=	"Получение сетевой лицензии";
var xmsgNSARTBeginMsg1=		"Способ отправки запроса активации файла сетевой лицензии:";
var xmsgNSARTBeginMsg2=		"Прямая связь (через Интернет)";
var xmsgNSARTBeginMsg3=		"По электронной почте, факсу или телефону";
var xmsgNSARTBeginNoInternet=	"";

/////////////////////////////////////////////
// Edit server and seat information
/////////////////////////////////////////////
var xmsgEditServerHdrMsg1=	"Информация о сервере";
var xmsgEditServerHdrMsg2=	"Модель сервера лицензий*";
var xmsgEditServerMsg1=		"Введите сведения о сервере лицензий.<br>"+
							"Поле кода хост-машины заполняется с помощью кнопки \"Определить\".<p>";
var xmsgEditServerMsg2=		"Начать с данных о сервере из существующих файлов лицензий.";
var xmsgEditServerRemove=	"Удалить";
var xmsgEditServerHostName=	"Имя хоста*";
var xmsgEditServerHostID=	"ID хоста*";
var xmsgEditServerSeat=		"Рабочие места*";
var xmsgEditServerSingle=	"Один сервер";
var xmsgEditServerDistributed=	"Распределенный сервер";
var xmsgEditServerRedundant=	"Резервный сервер";
var xmsgEditServerDots=		"...";
var xmsgEditServerLookup=	"Определить";
var xmsgEditServerAddServer=	"Добавить";
var xmsgEditServerRemoveServer=	"Удалить";
var xmsgEditServerTotal=	"Всего:";
var xmsgEditServerExceedMaxServer=	"Замечание: За один вызов процедуры можно получить лицензии не более чем для 20 распределенных серверов лицензий. Если число серверов превышает 20, свяжитесь с компанией Autodesk.";
var xmsgEditServerSeatError=	"Значение в поле количества рабочих мест должно быть числовым.";

var xmsgConfirmServerMsg=	"Проверьте приведенные здесь данные. Для продолжения нажмите \"Далее\", для внесения изменений -- \"Назад\".";
var xmsgConfirmServerMsg2=	"При нажатии кнопки \"Далее\" информация будет отправлена в компанию Autodesk по Интернету.";
var xmsgConfirmServerHdr2=	"Модель сервера лицензий:";
var xmsgConfirmServerHostName=	"Имя хоста";
var xmsgConfirmServerHostID=	"ID хоста";
var xmsgConfirmServerSeat=		"Рабочие места";
var xmsgConfirmServerTotal=		"Всего рабочих мест:";

var xmsgLicErrorHdr=			"Ошибка лицензирования"; 
var xmsgLicErrorInvalidSN=		"Введенный серийный номер является недействительным. Проверьте правильность отображаемого выше серийного номера. Щелкните одну из следующих ссылок.";
var xmsgLicReEnterSN=			"Введите серийный номер заново и повторите операцию.";

var xmsgLic113Msg2=				"Общее количество рабочих мест, выделенное распределенным серверам, превышает требуемое значение.";
var xmsgLic113ModifySeats=		"Измените распределение рабочих мест.";

var xmsgSaveLicenseHdr=			"Полученные лицензии";
var xmsgSaveLicenseMsg1=		"Вы получили лицензии от Autodesk.Теперь нужно сохранить их в файлах лицензий.<p> <b>Сохранение лицензий в файлах лицензий</b><p><LI><b>Рекомендуемым местоположением</b> файлов лицензий является папка \"License\", в которой на сервере размещен Autodesk Network License Manager.&nbsp;&nbsp;";
var xmsgSaveLicenseMsg6=		"<LI>Если у вас уже имеется <b>файл лицензий</b>, следует <b>вставить</b> новую лицензию в него.<br>При нажатии кнопки \"Далее\" система произведет вставку лицензии автоматически в нужную позицию файла.</LI>";
var xmsgSaveLicenseMsg2=		"Если указанный выше файл является файлом лицензий:";
var xmsgSaveLicenseMsg3=		"Вставить информацию о новой лицензии в него.";
var xmsgSaveLicenseMsg4=		"Заменить существующий файл лицензий.";
var xmsgSaveLicenseMsg5=		"Исправьте следующие ошибки:";

var xmsgSaveErrorFileNameTooLong=  "ОШИБКА. Введено слишком длинное имя файла.<br>" +
								"Перед продолжением измените имя файла.";
var xmsgSaveErrorNoPermission=	"ОШИБКА: У вас нет прав на сохранение файла в указанной папке.<br>Сейчас можно сохранить файл в какой-либо из доступных папок, а затем изменить права и переместить файл на отведенное ему место.";
var xmsgSaveErrorNoDiskSpace=	"ОШИБКА: На диске недостаточно пространства, чтобы сохранить файл в указанной папке.<BR>Сейчас можно сохранить файл в какой-либо из папок на другом диске, а затем очистить пространство и переместить файл на отведенное ему место.";
var xmsgSaveErrorInvalidFile=	"ОШИБКА: Новая лицензия не может быть добавлена в указанный файл без потери данных. Возможно, файл создан для других компьютеров или для другой модели серверов.<BR>Сейчас можно сохранить новый файл лицензий под другим именем, а затем добавить его к существующему файлу вручную.";															
var xmsgSaveErrorPathNotExit=	"ОШИБКА: Указанный путь не существует.<BR>Нажмите кнопку \"Обзор\", чтобы создать или найти путь.";
var xmsgSaveErrorPathBlank=		"ОШИБКА: Необходимо задать корректный путь и имя файла лицензий. Введите эти данные в поле ниже или разыщите файл на диске.";

var xmsgLicAuthConfirmHdr1=		"Активация лицензии успешно выполнена!";
var xmsgLicAuthConfirmHdr2=		"Информация о хосте сервера лицензий";
var xmsgLicAuthConfirmMsg1=		"Благодарим вас за регистрацию продукта. Данную информацию можно вывести на печать.";
var xmsgLicAuthConfirmDate=		"Дата:";

var xmsgLicPathMsg1=			"Сохранены следующие лицензии:";
var xmsgLicPathMsg2=			"Файлы лицензий сохранены в:";

var xmsgOtherMethodMsg1NSA=		"Используйте другой способ для получения авторизованной лицензии.";
var xmsgOtherMethodMsg1=		"Используйте другой способ.";

var xmsgContactAutodeskMsg1=	"Используйте один из следующих способов для связи с Autodesk.";
								
/////////////////////////////////////////////
// Email Options
/////////////////////////////////////////////
var xmsgEmailOptionNSATitle=	"Получение файла лицензии по электронной почте";
var xmsgEmailOptionTitle=		"Регистрация по электронной почте";
var xmsgEmailOptionNSAMsg=		"Регистрационная информация и сведения о сервере лицензий были автоматически сохранены в файле. Этот файл должен быть отправлен в систему обработки запросов на регистрацию Autodesk™.<p>После того как файл будет отправлен в Autodesk, вы получите автоматически сгенерированный ответ, файл с авторизованной лицензией и инструкции для завершения процесса.";
var xmsgEmailOptionMsg=			"Регистрационная информация была автоматически сохранена в файле. Этот файл должен быть отправлен в систему обработки запросов на регистрацию Autodesk™.<p>После того как файл будет отправлен в Autodesk, вы получите автоматически сгенерированный ответ и инструкции для завершения процесса.";
var xmsgEmailOptionMsg2=		"Если программа электронной почты настроена на отправку сообщений по Интернету, выберите \"Отправить файл сейчас\", а затем нажмите \"Далее\". Файл будет отправлен автоматически.<p>Если доступа к Интернету сейчас нет, выберите \"Отправить файл позже\". Вы получите инструкции о том, как отправить файл вручную.";
var xmsgEmailOptionInfo1=		"Отправить файл сейчас.";
var xmsgEmailOptionInfo2=		"Отправить файл позже (вручную).";
var xmsgEmailOptionInfo3=		"Отправить копию электронного сообщения на указанный адрес.";

/////////////////////////////////////////////
// Email Error
/////////////////////////////////////////////
var xmsgEmailErrorHdr=			"Не удается создать сообщение электронной почты";
var xmsgEmailErrorMsg1=			"Для завершения регистрации по электронной почте, вложите в сообщение следующий файл:";
var xmsgEmailErrorMsg2=			"Отправьте сообщение электронной почты по адресу %1.";
var xmsgEmailErrorMsg3=			"Файл можно найти в следующем месте:";

/////////////////////////////////////////////
// Local HERE customer information URLs
/////////////////////////////////////////////
var xmsgLocalHERETitle=			"Изменение данных о пользователе";
var xmsgLocalHEREInfo=			"Для изменения данных о пользователе обратитесь к авторизованному дилеру Autodesk или выберите ниже ссылку, соответствующую вашей стране или региону.";
var xmsgLocalHEREUS=			"Америка";
var xmsgLocalHEREEMEA=			"Европа, Ближний Восток, Африка";
var xmsgLocalHEREAPAC=			"Азиатско-тихоокеанский регион";

/////////////////////////////////////////////
// Help
/////////////////////////////////////////////
var xmsgHelpTitle=				"Справка";
var xmsgHelpUpgradeMsg=			"Если выполняется регистрация или активация предыдущей версии, необходимо установить этот флажок. После этого отобразится запрос на ввод серийного номера для обновляемой версии.";
var xmsgHelpUpgradeRequiredTitle=	"Введите серийный номер предыдущего продукта (требуется для обновления)";
var xmsgHelpUpgradeRequiredMsg=	"Это серийный номер для предыдущей версии программного обеспечения. Серийный номер можно узнать в диалоговом окне Справка > О программе программного обеспечения или на упаковке предыдущего продукта.";

//	Fax or email error message
var xmsgNotEnterErrorMsg=		"Не введен %1. Нажмите эту кнопку, если активацию требуется получить таким способом.";								

//  Help for serial number
var xmsgHelpSerialNumberTitle=  "Серийный номер/ код группы"; ////modify by joyce.min on 2007-8-16
var xmsgHelpSerialNumberMsg=    "Серийный номер указан на упаковке продукта или в сообщении электронной почты с информацией об обновлении и лицензировании программ Autodesk."; // ECO19

//  Help for ProductInfo serial number & Product Key //modify by joyce.min on 2007-8-16
var xmsgHelpProductKeyTitle=   "Ключ продукта";
var xmsgHelpProductKeyMsg=    "Ключ продукта указан рядом с серийным номером на упаковке продукта или в сообщении электронной почты с информацией об обновлении и лицензировании программ Autodesk."; // ECO19

/////////////////////////////////////////////
// The following strings are added back for backward competibility reason
/////////////////////////////////////////////
var xmsgRT0015TempSysErr=				"Ошибка подключения (0.15)";
var xmsgRT010203071213CannotCompErrA=	"Ошибка регистрации (1.2.3.7.12.13)";
var xmsgRT09AlreadyReg=					"Продукт уже зарегистрирован (9)";
var xmsgRT10ExceededAuths=				"Превышение числа авторизаций (10)";
var xmsgRT12StolenSN=					"Украденный серийный номер (12)";
var xmsgRT18OldSNInvalid=				"Прежний серийный номер неверен (18)";
var xmsgRT20DataError=					"Ошибка в данных (20)";
var xmsgRT21CustIDTelErr=				"Ошибочный код клиента или телефон (21)";
var xmsgRT22NetworkInstallation=		"Ошибка сетевой установки (22)";
var xmsgRT900SystemNotResponding=		"Система не отвечает (900)";
var xmsgRTCustID=						"Код клиента";
var xmsgRTCustIDConfirm=				"Подтверждение кода";
var xmsgRTNewSerialNumber=				"Новый серийный номер";
var xmsgRTNoNewSN=						"Ошибка при передаче данных";
var xmsgRTPurchAuthFailed=				"Ошибка при активации";
var xmsgRTPurchConfirmOther=			"Подтверждение приобретения";
var xmsgRTPurchConfirmPerm=				"Подтверждение приобретения - регистрация и активация выполнены";
var xmsgRTPurchConfirmReg=				"Подтверждение приобретения - продукт зарегистрирован, но не активирован";
var xmsgRTPurchConfirmRegVol=			"Подтверждение приобретения - продукт зарегистрирован";
var xmsgRTPurchConfirmRent=				"Подтверждение приобретения - продукт зарегистрирован и передан во временное пользование";
var xmsgRTPurchConfirmUnReg=			"Подтверждение приобретения - регистрация и активация не выполнены";
var xmsgRTPurchConnectionFailed=		"Ошибка при приобретении продукта";
var xmsgRTPurchaseError=				"Ошибка при приобретении";
var xmsgRTSNMismatch=					"Ошибка при приобретении продукта - Несоответствие серийных номеров";
var xmsgRTSUNOldSNInvalid=				"Прежний серийный номер неверен";

var szRTEmail =         "RTEmail.html";

var xmsgExit=			"Выход";

var xmsgCustIDMainTitle=	"Идентификация пользователя";
var xmsgCustIDTitle1=		"Код клиента:";
var xmsgCustIDText2=		"Введите код пользователя и номер телефона. Если у вас нет кода пользователя, оставьте оба поля пустыми.<p> ";
var xmsgCustIDText3=		"Примечание. В случае повторной активации продукта необходимо ввести код пользователя.";
var xmsgCustIDText3NSA=		"Примечание. В случае повторной авторизации продукта необходимо ввести код пользователя.";
var xmsgCustIDTitle2=		"Номер телефона:";
var xmsgCustIDTelEx4=		"(пример: 03-111-1234)";
var xmsgRegCustIDTel=		"Введенные код пользователя и номер телефона не соответствуют нашим данным. Щелкните одну из следующих ссылок.";

/////////////////////////////////////////////
//  Note to Localization :
//
//	"xmsgRT113SeatMsg1" appears in NSA_RT113TooManySeats.html.  The full sentence in English is
//
//	"Our records indicate that you have [Max allowed seats] valid [product name] seats available." 
/////////////////////////////////////////////
var xmsgRT113SeatMsg1=	"Согласно нашим данным, у вас имеется %1 рабочих мест с %2.<br>";

/////////////////////////////////////////////
// Error 12
/////////////////////////////////////////////
var xmsgErr12Hdr=				"Введенный серийный номер является недействительным";
var xmsgErr12APAC=				"<p>Это недействительный серийный номер, и активация невозможна. Обратитесь по адресу <a href=mailto:apacpl@listproc.autodesk.com target=\"_blank\">apacpl@listproc.autodesk.com</a></p>";
var xmsgErr12EMEA=				"<p>Уважаемый господин/госпожа!</p>" +
								"<p>Вы пытались зарегистрировать программный продукт Autodesk&#0174; или Discreet&#0153; в компании Autodesk.</p>" +
								"<p>К сожалению, по нашим данным  серийный номер для регистрации программного продукта Autodesk&#0174; "+
								"или Discreet&#0153;, который Вы пытались зарегистрировать у нас, является недействительным или совпадает с серийным номером "+
								"известной пиратской копии программного продукта, поэтому используемый Вами " +
								"программный продукт Autodesk&#0174; или Discreet&#0153; является неавторизованным.</p>" +
								"<p>Лицензии на использование программных продуктов Autodesk&#0174; могут быть приобретены у авторизованных " +
								"дилеров Autodesk. Со списком авторизованных дилеров Autodesk " +
								"или отделений Autodesk в вашем регионе можно ознакомиться на веб-узле " +
								"<a href=\"http://www.autodesk.com\" target=\"_blank\">www.autodesk.com</a>. " +
								"Использование легально приобретенного программного обеспечения - " +
								"это единственный способ, гарантирующий вам максимальные выгоды при использовании программного обеспечения И отсутствие возможного гражданского " +
								"и уголовного преследования, связанногос незаконным использованием и/или воспроизведением программного обеспечения.</p>" +
								"<p>Лицензии на использование программных продуктов Discreet&#0153; можно приобрести у авторизованных  " +
								"дилеров Discreet. Со списком авторизованных дилеров Discreet " +
								"или отделений Discreet в вашем регионе можно ознакомиться на веб-узле " +
								"<a href=\"http://www.discreet.com\" target=\"_blank\">www.discreet.com</a>. " +
								"Использование легально приобретенного программного обеспечения - " +
								"это единственный способ, гарантирующий вам максимальные выгоды при использовании программного обеспечения И отсутствие возможного гражданского " +
								"и уголовного преследования, связанного с незаконным использованием и/или воспроизведением программного обеспечения.</p>" +
								"<p>Поэтому мы убедительно просим вас немедленно прекратить использование неавторизованных программных продуктов, " +
								"которые вы пытались у нас зарегистрировать, удалить все его копии, хранящиеся на имеющемся у вас компьютерном оборудовании, и " +
								"уничтожить все носители, содержащие программный продукт. Мы надеемся, что вы добровольно выполните наше требование, " +
								"однако  Autodesk сохраняет все права, возникающие в подобных ситуациях, и может передать данные о вас " +
								"в ассоциацию Business Software Alliance (\"BSA\").</p>" +
								"<p>Если у вас возникли какие-либо вопросы или вы считаете, что получили это сообщение по ошибке, свяжитесь" +
								"с нами  по адресу: " + 
								"<a href=mailto:emea.register@activation.autodesk.com target=\"_blank\">emea.register@activation.autodesk.com</a></p>" +
								"<p>Если вы захотите предоставить информацию об использовании или продаже незаконных копий программного обеспечения, " +
								"обратитесь в местное отделение Autodesk или в ассоциацию BSA, посетив веб-узел " +
								"<a href=\"http://www.BSA.org\" target=\"_blank\">www.BSA.org</a></p>" +
								"<p>Спасибо.</p>";
var xmsgErr12US=				"<p>Уважаемый господин/уважаемая госпожа,</p><p>Вы пытались зарегистрировать программный продукт Autodesk или Discreet.</p><p>К сожалению, по нашим данным, серийный номер для программного продукта Autodesk&#0174; или Discreet&#0153;, который вы пытались зарегистрировать у нас, является недействительным или совпадает с серийным номером хорошо известной пиратской копии программного продукта, поэтому используемый вами программный продукт Autodesk&#0174; или Discreet&#0153; является неавторизованным.</p><p>Пользователи Autodesk могут приобрести лицензии на программные продукты Autodesk&#0174; у авторизованных дилеров Autodesk. Со списком авторизованных дилеров Autodesk или отделений Autodesk в вашем регионе можно ознакомиться на веб-узле <a href=\"http://www.autodesk.com\" target=\"_blank\">www.autodesk.com</a>. Использование легально приобретенного программного обеспечения - это единственный способ, гарантирующий вам максимальные выгоды при использовании программного обеспечения И отсутствие возможного гражданского и уголовного преследования, связанного с незаконным использованием и/или воспроизведением программного обеспечения.</p><p>Пользователи Discreet&#0153; могут приобрести лицензии на использование программных продуктов Discreet&#0153; у авторизованных дилеров Discreet. Со списком авторизованных дилеров Discreet или отделений Discreet в вашем регионе можно ознакомиться на веб-узле <a href=\"http://www.discreet.com\" target=\"_blank\">www.discreet.com</a>. Использование легально приобретенного программного обеспечения - это единственный способ, гарантирующий вам максимальные выгоды при использовании программного обеспечения И отсутствие возможного гражданского и уголовного преследования, связанного с незаконным использованием и/или воспроизведением программного обеспечения.</p><p>Поэтому мы убедительно просим вас немедленно прекратить использование неавторизованных программных продуктов, которые вы пытались у нас зарегистрировать, удалить все его копии, хранящиеся на имеющемся у вас компьютерном оборудовании, и уничтожить все носители, содержащие программный продукт. Мы надеемся, что вы добровольно выполните наше требование, однако Autodesk сохраняет свои права, возникающие в подобных ситуациях, и может передать данные о вас в ассоциацию Business Software Alliance (“BSA”).</p><p>Если у вас возникли какие-либо вопросы или вы считаете, что получили это сообщение по ошибке, свяжитесь с нами по адресу: <a href=mailto:ProductActivation@activation.autodesk.com target=\"_blank\">ProductActivation@activation.autodesk.com</a></p><p>IЕсли вы захотите предоставить информацию об использовании или продаже незаконных копий программного обеспечения, обратитесь в местное отделение Autodesk или в ассоциацию BSA, посетив веб-узел <a href=\"http://www.BSA.org\" target=\"_blank\">www.BSA.org</a></p><p>Спасибо</p>";






// SIG // Begin signature block
// SIG // MIIVVAYJKoZIhvcNAQcCoIIVRTCCFUECAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFMdJoW1/wl8E
// SIG // Rge7tPGJBTwHsma5oIIRFjCCA3owggJioAMCAQICEDgl
// SIG // 1/r4Ya+e9JDnJrXWWtUwDQYJKoZIhvcNAQEFBQAwUzEL
// SIG // MAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJ
// SIG // bmMuMSswKQYDVQQDEyJWZXJpU2lnbiBUaW1lIFN0YW1w
// SIG // aW5nIFNlcnZpY2VzIENBMB4XDTA3MDYxNTAwMDAwMFoX
// SIG // DTEyMDYxNDIzNTk1OVowXDELMAkGA1UEBhMCVVMxFzAV
// SIG // BgNVBAoTDlZlcmlTaWduLCBJbmMuMTQwMgYDVQQDEytW
// SIG // ZXJpU2lnbiBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIFNp
// SIG // Z25lciAtIEcyMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCB
// SIG // iQKBgQDEtfJSFbyIhmApFkpbL0uRa4eR8zVUWDXq0TZe
// SIG // Yk1SUTRxwntmHYnI3SrEagr2N9mYdJH2kq6wtXaW8alK
// SIG // Y0VHLmsLkk5LK4zuWEqL1AfkGiz4gqpY2c1C8y3Add6N
// SIG // q8eOHZpsTAiVHt7b72fhcsJJwp5gPOHivhajY3hpFHut
// SIG // LQIDAQABo4HEMIHBMDQGCCsGAQUFBwEBBCgwJjAkBggr
// SIG // BgEFBQcwAYYYaHR0cDovL29jc3AudmVyaXNpZ24uY29t
// SIG // MAwGA1UdEwEB/wQCMAAwMwYDVR0fBCwwKjAooCagJIYi
// SIG // aHR0cDovL2NybC52ZXJpc2lnbi5jb20vdHNzLWNhLmNy
// SIG // bDAWBgNVHSUBAf8EDDAKBggrBgEFBQcDCDAOBgNVHQ8B
// SIG // Af8EBAMCBsAwHgYDVR0RBBcwFaQTMBExDzANBgNVBAMT
// SIG // BlRTQTEtMjANBgkqhkiG9w0BAQUFAAOCAQEAUMVLyCSA
// SIG // 3+QNJMLeGrGhAqGmgi0MgxWBNwqCDiywWhdhtdgF/ojb
// SIG // 8ZGRs1YaQKbrkr44ObB1NnQ6mE/kN7qZicqVQh2wuceg
// SIG // jVfg+tVkBEI1TgHRM6IXyE2qJ8fy4YZMAjhNg3jG/FPg
// SIG // 6+AGh92klp5eDJjipb6/goXDYOHfrSjYx6VLZNrHG1u9
// SIG // rDkI1TgioTOLL4qa67wHIT9EQQkHtWUcJLxI00SA66HP
// SIG // yQK0FM9UxxajgFz5eT5dcn2IF54sQ6LKU859PfYqOrhP
// SIG // lAClbQqDXfleU/QYs1cPcMP79a2VoA4X3sQWgGDJDytu
// SIG // hgTx6/R4J9EFxe40W165STLyMzCCA8QwggMtoAMCAQIC
// SIG // EEe/GZXfjVJGQ/fbbUgNMaQwDQYJKoZIhvcNAQEFBQAw
// SIG // gYsxCzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJu
// SIG // IENhcGUxFDASBgNVBAcTC0R1cmJhbnZpbGxlMQ8wDQYD
// SIG // VQQKEwZUaGF3dGUxHTAbBgNVBAsTFFRoYXd0ZSBDZXJ0
// SIG // aWZpY2F0aW9uMR8wHQYDVQQDExZUaGF3dGUgVGltZXN0
// SIG // YW1waW5nIENBMB4XDTAzMTIwNDAwMDAwMFoXDTEzMTIw
// SIG // MzIzNTk1OVowUzELMAkGA1UEBhMCVVMxFzAVBgNVBAoT
// SIG // DlZlcmlTaWduLCBJbmMuMSswKQYDVQQDEyJWZXJpU2ln
// SIG // biBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIENBMIIBIjAN
// SIG // BgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqcqypMzN
// SIG // IK8KfYmsh3XwtE7x38EPv2dhvaNkHNq7+cozq4QwiVh+
// SIG // jNtr3TaeD7/R7Hjyd6Z+bzy/k68Numj0bJTKvVItq0g9
// SIG // 9bbVXV8bAp/6L2sepPejmqYayALhf0xS4w5g7EAcfrkN
// SIG // 3j/HtN+HvV96ajEuA5mBE6hHIM4xcw1XLc14NDOVEpkS
// SIG // ud5oL6rm48KKjCrDiyGHZr2DWFdvdb88qiaHXcoQFTyf
// SIG // hOpUwQpuxP7FSt25BxGXInzbPifRHnjsnzHJ8eYiGdvE
// SIG // s0dDmhpfoB6Q5F717nzxfatiAY/1TQve0CJWqJXNroh2
// SIG // ru66DfPkTdmg+2igrhQ7s4fBuwIDAQABo4HbMIHYMDQG
// SIG // CCsGAQUFBwEBBCgwJjAkBggrBgEFBQcwAYYYaHR0cDov
// SIG // L29jc3AudmVyaXNpZ24uY29tMBIGA1UdEwEB/wQIMAYB
// SIG // Af8CAQAwQQYDVR0fBDowODA2oDSgMoYwaHR0cDovL2Ny
// SIG // bC52ZXJpc2lnbi5jb20vVGhhd3RlVGltZXN0YW1waW5n
// SIG // Q0EuY3JsMBMGA1UdJQQMMAoGCCsGAQUFBwMIMA4GA1Ud
// SIG // DwEB/wQEAwIBBjAkBgNVHREEHTAbpBkwFzEVMBMGA1UE
// SIG // AxMMVFNBMjA0OC0xLTUzMA0GCSqGSIb3DQEBBQUAA4GB
// SIG // AEpr+epYwkQcMYl5mSuWv4KsAdYcTM2wilhu3wgpo17I
// SIG // ypMT5wRSDe9HJy8AOLDkyZNOmtQiYhX3PzchT3AxgPGL
// SIG // OIez6OiXAP7PVZZOJNKpJ056rrdhQfMqzufJ2V7duyuF
// SIG // PrWdtdnhV/++tMV+9c8MnvCX/ivTO1IbGzgn9z9KMIIE
// SIG // vzCCBCigAwIBAgIQQZGhWjl4389JZWY4HUx1wjANBgkq
// SIG // hkiG9w0BAQUFADBfMQswCQYDVQQGEwJVUzEXMBUGA1UE
// SIG // ChMOVmVyaVNpZ24sIEluYy4xNzA1BgNVBAsTLkNsYXNz
// SIG // IDMgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBB
// SIG // dXRob3JpdHkwHhcNMDQwNzE2MDAwMDAwWhcNMTQwNzE1
// SIG // MjM1OTU5WjCBtDELMAkGA1UEBhMCVVMxFzAVBgNVBAoT
// SIG // DlZlcmlTaWduLCBJbmMuMR8wHQYDVQQLExZWZXJpU2ln
// SIG // biBUcnVzdCBOZXR3b3JrMTswOQYDVQQLEzJUZXJtcyBv
// SIG // ZiB1c2UgYXQgaHR0cHM6Ly93d3cudmVyaXNpZ24uY29t
// SIG // L3JwYSAoYykwNDEuMCwGA1UEAxMlVmVyaVNpZ24gQ2xh
// SIG // c3MgMyBDb2RlIFNpZ25pbmcgMjAwNCBDQTCCASIwDQYJ
// SIG // KoZIhvcNAQEBBQADggEPADCCAQoCggEBAL687rx+74Pr
// SIG // 4DdP+wMQOL4I0ox9nfqSfxkMwmvuQlKM3tMcSBMl6sFj
// SIG // evlRZe7Tqjv18JScK/vyZtQk2vf1n24ZOTa80KN2CB4i
// SIG // JyRsOJEn4oRJrhuKof0lgiwQMOhxqyjod0pR8ezN+PBU
// SIG // 1G/A420Kj9nYZI1jsi1OJ/aFDv5t4ymZ4oVHfC2Gf+hX
// SIG // j61nwjMykRMg/KkjFJptwoRLdmgE1XEsXSH6iA0m/R8t
// SIG // kSvnAVVN8m01KILf2WtcttbZqoH9X82DumOd0CL8qTtC
// SIG // abKOOrW8tJ4PXsTqLIKLKP1TCJbdtQEg0fmlGOfA7lFw
// SIG // N+G2BUhSSG846sPobHtEhLsCAwEAAaOCAaAwggGcMBIG
// SIG // A1UdEwEB/wQIMAYBAf8CAQAwRAYDVR0gBD0wOzA5Bgtg
// SIG // hkgBhvhFAQcXAzAqMCgGCCsGAQUFBwIBFhxodHRwczov
// SIG // L3d3dy52ZXJpc2lnbi5jb20vcnBhMDEGA1UdHwQqMCgw
// SIG // JqAkoCKGIGh0dHA6Ly9jcmwudmVyaXNpZ24uY29tL3Bj
// SIG // YTMuY3JsMB0GA1UdJQQWMBQGCCsGAQUFBwMCBggrBgEF
// SIG // BQcDAzAOBgNVHQ8BAf8EBAMCAQYwEQYJYIZIAYb4QgEB
// SIG // BAQDAgABMCkGA1UdEQQiMCCkHjAcMRowGAYDVQQDExFD
// SIG // bGFzczNDQTIwNDgtMS00MzAdBgNVHQ4EFgQUCPVR6Pv+
// SIG // PT1kNnxoz1t4qN+5xTcwgYAGA1UdIwR5MHehY6RhMF8x
// SIG // CzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwg
// SIG // SW5jLjE3MDUGA1UECxMuQ2xhc3MgMyBQdWJsaWMgUHJp
// SIG // bWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eYIQcLrk
// SIG // HRDZKTS2OMp7A8y6vzANBgkqhkiG9w0BAQUFAAOBgQCu
// SIG // Ohe4SntV+mRV7ECk7UlBkJmcibyvLh3KeCP5HBkPf+to
// SIG // vDLZiDje3D/TibQ/sYKW8aRauu0uJtPefAFuAAoApAaS
// SIG // EUgJQPkcGHlnIyTgu9XhUK4b9Q7d4C6BzYCjbFJPkXVV
// SIG // iroi8tLqQXWIL2NVfR5UWpVZytk0gcBfXvZ6tTCCBQkw
// SIG // ggPxoAMCAQICEErej526uUojb1I0pA35Pn4wDQYJKoZI
// SIG // hvcNAQEFBQAwgbQxCzAJBgNVBAYTAlVTMRcwFQYDVQQK
// SIG // Ew5WZXJpU2lnbiwgSW5jLjEfMB0GA1UECxMWVmVyaVNp
// SIG // Z24gVHJ1c3QgTmV0d29yazE7MDkGA1UECxMyVGVybXMg
// SIG // b2YgdXNlIGF0IGh0dHBzOi8vd3d3LnZlcmlzaWduLmNv
// SIG // bS9ycGEgKGMpMDQxLjAsBgNVBAMTJVZlcmlTaWduIENs
// SIG // YXNzIDMgQ29kZSBTaWduaW5nIDIwMDQgQ0EwHhcNMDgw
// SIG // MzIwMDAwMDAwWhcNMDkwMzIwMjM1OTU5WjCBzDELMAkG
// SIG // A1UEBhMCVVMxEzARBgNVBAgTCkNhbGlmb3JuaWExEzAR
// SIG // BgNVBAcTClNhbiBSYWZhZWwxFzAVBgNVBAoUDkF1dG9k
// SIG // ZXNrLCBJbmMuMSEwHwYDVQQLFBhQU0VCLUxpY2Vuc2lu
// SIG // ZyAmIEluc3RhbGwxPjA8BgNVBAsTNURpZ2l0YWwgSUQg
// SIG // Q2xhc3MgMyAtIE1pY3Jvc29mdCBTb2Z0d2FyZSBWYWxp
// SIG // ZGF0aW9uIHYyMRcwFQYDVQQDFA5BdXRvZGVzaywgSW5j
// SIG // LjCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAp+6n
// SIG // nTaWIaaik4EgXpsaskB3OTSOClzOXYCXAb72SwJCpwl9
// SIG // vER/uhH7cq2P7d6UNPue0OFVpr73qgMo0/TVXms6jug1
// SIG // n+nHo55JZcMOaDDprfsuuDznAmsiMoZoAdnMO1n3ZBbp
// SIG // gXcZ6xujdhb+wllM1s165yyYM+tTZlI53s8CAwEAAaOC
// SIG // AX8wggF7MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeA
// SIG // MEAGA1UdHwQ5MDcwNaAzoDGGL2h0dHA6Ly9DU0MzLTIw
// SIG // MDQtY3JsLnZlcmlzaWduLmNvbS9DU0MzLTIwMDQuY3Js
// SIG // MEQGA1UdIAQ9MDswOQYLYIZIAYb4RQEHFwMwKjAoBggr
// SIG // BgEFBQcCARYcaHR0cHM6Ly93d3cudmVyaXNpZ24uY29t
// SIG // L3JwYTATBgNVHSUEDDAKBggrBgEFBQcDAzB1BggrBgEF
// SIG // BQcBAQRpMGcwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3Nw
// SIG // LnZlcmlzaWduLmNvbTA/BggrBgEFBQcwAoYzaHR0cDov
// SIG // L0NTQzMtMjAwNC1haWEudmVyaXNpZ24uY29tL0NTQzMt
// SIG // MjAwNC1haWEuY2VyMB8GA1UdIwQYMBaAFAj1Uej7/j09
// SIG // ZDZ8aM9beKjfucU3MBEGCWCGSAGG+EIBAQQEAwIEEDAW
// SIG // BgorBgEEAYI3AgEbBAgwBgEBAAEB/zANBgkqhkiG9w0B
// SIG // AQUFAAOCAQEAoPt/JaNzwVvcuubHYt0M860+ntlMVoew
// SIG // XuvpZovRS8qzZTdLQDOGL4DL5GfVcC3t8YyomUYLJ7Rh
// SIG // BGhjuPyDtinUxw85rWZ+OHDkSvmPL0seDyJeUELj17qU
// SIG // JHCwJyeAErkw8vt7Tyi8XZjF2YP3PCGBYTX2s2qMTlXZ
// SIG // z6nqHnbN564AtxqBHcu4HXoKUT28fFhZEmYIANzmRaTi
// SIG // ZBYFFxaAf89H9xBSE+WqOiLP0W7FGJ6FTRyCIAkwFOfY
// SIG // Xi34nFfP62xKRrD7O2BPKI1mMlUSizqRFpooCWfjZjcw
// SIG // XWGQu6TZ9Xf+1DoLHrYbOPIjmpuTEyZtr8s94s/9eof6
// SIG // pDGCA6owggOmAgEBMIHJMIG0MQswCQYDVQQGEwJVUzEX
// SIG // MBUGA1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsT
// SIG // FlZlcmlTaWduIFRydXN0IE5ldHdvcmsxOzA5BgNVBAsT
// SIG // MlRlcm1zIG9mIHVzZSBhdCBodHRwczovL3d3dy52ZXJp
// SIG // c2lnbi5jb20vcnBhIChjKTA0MS4wLAYDVQQDEyVWZXJp
// SIG // U2lnbiBDbGFzcyAzIENvZGUgU2lnbmluZyAyMDA0IENB
// SIG // AhBK3o+durlKI29SNKQN+T5+MAkGBSsOAwIaBQCggbQw
// SIG // GQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYB
// SIG // BAGCNwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcN
// SIG // AQkEMRYEFDEUEI5l9XKmYvtZhT9P59vdtVaiMFQGCisG
// SIG // AQQBgjcCAQwxRjBEoCaAJABBAHUAdABvAGQAZQBzAGsA
// SIG // IABDAG8AbQBwAG8AbgBlAG4AdKEagBhodHRwOi8vd3d3
// SIG // LmF1dG9kZXNrLmNvbSAwDQYJKoZIhvcNAQEBBQAEgYAd
// SIG // MPixkBGB8FTaPiwKE2McVG0NV/pe2wa4aYIjtSPBR7bP
// SIG // GYsbFuG80MxcfJINSgpFWhiIL5wmr+9mdQkkUo8Yz7Y3
// SIG // ZHQAnyY+LOExoaVQt7ZZMdjvQ0Q5AYlmX9VH8PE9u5jW
// SIG // mhh0/AOBzJvufbqJC5xetzlzfoY+U37t4ppWfaGCAX8w
// SIG // ggF7BgkqhkiG9w0BCQYxggFsMIIBaAIBATBnMFMxCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjErMCkGA1UEAxMiVmVyaVNpZ24gVGltZSBTdGFtcGlu
// SIG // ZyBTZXJ2aWNlcyBDQQIQOCXX+vhhr570kOcmtdZa1TAJ
// SIG // BgUrDgMCGgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqGSIb3
// SIG // DQEHATAcBgkqhkiG9w0BCQUxDxcNMDkwMjAzMjMyOTI2
// SIG // WjAjBgkqhkiG9w0BCQQxFgQUnRnWsEcuSsmL7e8PoAKQ
// SIG // T2se3rwwDQYJKoZIhvcNAQEBBQAEgYBoHDXxvtQMNNWP
// SIG // Euvcn5VsIQ0Vd6NyvV8RZ2h/m+SMt6KFC+Et4U7Gl71m
// SIG // ylb4x0Aqv7YohIpve3G7e4vLShUeFFy15ZpU/Zcj+lEj
// SIG // bze4WKdGgwEzAYnUxDHkr/5LWk7TXquu83SEA9231YU7
// SIG // 7KUrDTGFOwaZ/SVR0QDzhgI+vg==
// SIG // End signature block
